<?php
// app/Controllers/SupplierController.php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\SupplierRepository;

class SupplierController extends Controller
{
    private SupplierRepository $repo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new SupplierRepository($db);
    }

    public function index()
    {
        // vrací SupplierEntity[]
        $items = $this->repo->findAll();
        $this->view->render('suppliers/index', ['suppliers' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=supplier&action=index');
        }
        $this->view->render('suppliers/form');
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $supplier = $this->repo->find($id);
        if (!$supplier) {
            http_response_code(404);
            echo 'Dodavatel nenalezen';
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=supplier&action=index');
        }

        $this->view->render('suppliers/edit', ['supplier' => $supplier]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=supplier&action=index');
    }

    public function show()
    {
        $id = (int)($_GET['id'] ?? 0);
        $supplier = $this->repo->find($id);
        if (!$supplier) {
            http_response_code(404);
            echo 'Dodavatel nenalezen';
            exit;
        }
        $this->view->render('suppliers/show', ['supplier' => $supplier]);
    }

    /**
     * Základní validace vstupu z formuláře.
     * Vrací pole připravené pro repository (create/update).
     */
    private function validate(array $input): array
    {
        return [
            'name'  => trim($input['name'] ?? ''),
            'email' => trim($input['email'] ?? ''),
            'phone' => trim($input['phone'] ?? ''),
            'vip' => trim($input['vip'] ?? '')
        ];
    }
}